/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.controller;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

import de.hwrBerlin.hwrchat.clientTest.listener.IMessageReceiveListener;
import de.hwrBerlin.hwrchat.model.messages.AMessage;
import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FindUserRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FriendshipRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GroupAttendRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;

/**
 * @author Nico Smeenk
 * 
 *         Diese Klasse kmmert dich um das Empfangen von Daten die der Server sendet. Die Daten werden direkt an die Observer weitergeleitet.
 * 
 */
public class ReceiveMessageTread implements Runnable {
    
    /** Liste der Listener bzw. observer die auf den Server lauschen */
    private List<IMessageReceiveListener> _listener = new ArrayList<IMessageReceiveListener>();
    
    /** Speichert den herreinkommenen Datenfluss */
    private ObjectInputStream _inputSteam;
    
    

    /**
     * Konstruktor
     */
    public ReceiveMessageTread(final ObjectInputStream pInputStream) {
        _inputSteam = pInputStream;
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
        while (true) {
            try {
                AMessage receivedObject = (AMessage) _inputSteam.readObject();
                System.out.println("" + receivedObject.getClass());
                // Loginnachricht
                if (receivedObject instanceof ConnectionRequestMessage) {
                    notifyLogin((ConnectionRequestMessage) receivedObject);
                }
                // Textnachricht
                else if (receivedObject instanceof TextMessage) {
                    notifyTextMessage((TextMessage) receivedObject);
                }
                // Aktualisisierung
                else if (receivedObject instanceof UpdatedAdressMessage) {
                    notifyAddressUpdate((UpdatedAdressMessage) receivedObject);
                }
                // Freundschaftsanfrage
                else if (receivedObject instanceof FriendshipRequestMessage) {
                    notifyFriendshipRequest((FriendshipRequestMessage) receivedObject);
                }
                // Gruppeneinladung
                else if (receivedObject instanceof GroupAttendRequestMessage) {
                    notifyGroupRequest((GroupAttendRequestMessage) receivedObject);
                }
                // Dateibertragung anfrage bzw straten
                else if (receivedObject instanceof FileTransferRequestMessage) {
                    if (!((FileTransferRequestMessage) receivedObject).isReverseRelation()) {
                        notifyFileTransferRequest((FileTransferRequestMessage) receivedObject);
                    }
                    else {
                        notyfyStartFileTransfer((FileTransferRequestMessage) receivedObject);
                    }
                }
                // Suchergebnis
                else if (receivedObject instanceof FindUserRequestMessage) {
                    notifyUserSerchResult((FindUserRequestMessage) receivedObject);
                }
            }
            catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }
    


    // ====================================================================================
    // ab hier geht es um das Observerprinzip
    // ====================================================================================
    


    /**
     * @param pReceivedObject
     */
    private void notifyUserSerchResult(FindUserRequestMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyUserSerchResult(pMessage);
        }
    }
    


    /**
     * @param pReceivedObject
     */
    private void notyfyStartFileTransfer(FileTransferRequestMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyStartFileTransfer(pMessage);
        }
        if (pMessage.isValidated()) {
            Thread thread = new Thread(new FileTransferThread(pMessage));
            thread.start();
        }
    }
    


    /**
     * @param pReceivedObject
     */
    private void notifyFileTransferRequest(FileTransferRequestMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyFileTransferRequest(pMessage);
        }
    }
    


    /**
     * @param pReceivedObject
     */
    private void notifyGroupRequest(GroupAttendRequestMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyGroupRequest(pMessage);
        }
    }
    


    /**
     * @param pReceivedObject
     */
    private void notifyFriendshipRequest(FriendshipRequestMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyFriendshipRequest(pMessage);
        }
    }
    


    /**
     * @param pReceivedObject
     */
    private void notifyAddressUpdate(UpdatedAdressMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyAddressUpdate(pMessage);
        }
    }
    


    /**
     * Schickt die Nachtichtsdaten
     * 
     * @param pReceivedObject
     */
    private void notifyTextMessage(TextMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyText(pMessage);
        }
    }
    


    /**
     * schickt die Daten beim Login weiter
     * 
     * @param pMessage
     *            Daten
     */
    private void notifyLogin(ConnectionRequestMessage pMessage) {
        for (IMessageReceiveListener listener : _listener) {
            listener.notifyLogin(pMessage);
        }
    }
    


    /**
     * Fgt den beobachtenden die ausgewhlte einheit hinzu
     * 
     * @param pListener
     *            Neuer listener
     */
    public void addListener(IMessageReceiveListener pListener) {
        _listener.add(pListener);
    }
    


    /**
     * Lscht einen beobachter aus der Liste
     * 
     * @param pListener
     *            zu lschender Listener
     * @return gibt zurck ob es gelscht werden konnte
     */
    public boolean removeListener(IMessageReceiveListener pListener) {
        return _listener.remove(pListener);
    }
}
