/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.controller;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;

import de.hwrBerlin.hwrchat.model.messages.FileTransferMessage;

/**
 * @author Nico Smeenk
 * 
 */
public class FileTransferWaitingThread implements Runnable {
    
    private String _path;

    private int _port;
    
    /**
     * 
     */
    public FileTransferWaitingThread(String pPath, int pPort) {
        _path = pPath;
        _port = pPort;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
        ServerSocket serverSock;
        try {
            serverSock = new ServerSocket(_port);
            Socket clientSocket = serverSock.accept();
            
            ObjectInputStream inputStream = new ObjectInputStream(clientSocket.getInputStream());
            
            Object object = inputStream.readObject();
            
            if (object instanceof FileTransferMessage) {
                byte[] bytes = ((FileTransferMessage) object).getFileInBytes();
                
                File file = new File(_path + ((FileTransferMessage) object).getFileName());
                file.createNewFile();
                
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(bytes);
                
                fileOutputStream.close();
                
                inputStream.close();
                serverSock.close();
                
            }
            
        }
        catch (ClassNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }
    
}
