/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import de.hwrBerlin.hwrchat.model.messages.FileTransferMessage;
import de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage;

/**
 * @author Nico Smeenk
 * 
 */
public class FileTransferThread implements Runnable {
    
    private InetAddress _sendTo;
    private int _port;
    private File _file;
    
    

    /**
     * 
     */
    public FileTransferThread(FileTransferRequestMessage pMessage) {
        _sendTo = pMessage.getIpAdressFromOriginalReciever();
        _port = pMessage.getFileTransferPort();
        _file = pMessage.getRequestFile();
        System.out.println(_sendTo.getHostAddress());
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
        try {
            Socket socket = new Socket(_sendTo, _port);
            
            ObjectOutputStream output = new ObjectOutputStream(socket.getOutputStream());
            
            FileTransferMessage message = new FileTransferMessage();
            byte fileBytes[] = new byte[(int) _file.length()];
            FileInputStream fileInputStream = new FileInputStream(_file);
            fileInputStream.read(fileBytes);
            message.setFileInBytes(fileBytes);
            message.setFileName(_file.getName());
            
            output.writeObject(message);
            socket.close();
        }
        catch (UnknownHostException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
    }
    
}
