/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import de.hwrBerlin.hwrchat.clientTest.exceptionhandling.ExceptionConstants;
import de.hwrBerlin.hwrchat.clientTest.exceptionhandling.ShowableException;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.clientTest.listener.IMessageReceiveListener;
import de.hwrBerlin.hwrchat.model.Address;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.Status;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;

/**
 * @author Nico Smeenk
 * 
 *         Alles was die View machen mchte wird hier zentral abgehandelt
 */
public class Controller extends AMessageReceiveAdapter {
    
    /** Speichert die Daten aus der Config Datei */
    private Map<String, String> _configs;
    /** kmmert dich um das Senden an den Server */
    private SendMessageController _sendMessageController;
    /** kmmert sich um das empfangen des Clients */
    private ReceiveMessageTread _receiveMessageThread;
    /** Thread */
    private Thread _receiverThread;
    /** momentan angemeldeter User */
    private User _currentUser;
    
    

    /**
     * Konstruktor
     */
    public Controller() {
        // Configdatei auslesen
        _configs = new ConfigManager(false).readConfig();
    }
    


    /**
     * Stellt eine Verbindung zum Server her
     */
    public void connectToServer() {
        try {
            Socket socket = new Socket(_configs.get(ConfigConstants.CLIENT_SERVER_LOCAION),
                    Integer.parseInt(_configs.get(ConfigConstants.CLIENT_SERVER_PORT)));
            ObjectInputStream inputSteam = new ObjectInputStream(socket.getInputStream());
            ObjectOutputStream outputSteam = new ObjectOutputStream(socket.getOutputStream());
            
            _sendMessageController = new SendMessageController(outputSteam);
            _receiveMessageThread = new ReceiveMessageTread(inputSteam);
            addListener(this);
            _receiverThread = new Thread(_receiveMessageThread);
            _receiverThread.start();
            
            _receiveMessageThread.addListener(this);
        }
        catch (NumberFormatException e) {
            throw new ShowableException(ExceptionConstants.PORT_NO_INTEGER_TITLE,
                    ExceptionConstants.PORT_NO_INTEGER_MESSAGE);
        }
        catch (UnknownHostException e) {
            throw new ShowableException(ExceptionConstants.UNKNOWEN_HOST_TITLE,
                    ExceptionConstants.UNKNOWEN_HOST_MESSAGE);
        }
        catch (IOException e) {
            throw new ShowableException(ExceptionConstants.CONNECTION_IO_EXCEPTION_TITLE,
                    ExceptionConstants.CONNECTION_IO_EXCEPTION_MESSAGE + "\n\n" + e.getMessage());
        }
    }
    


    /**
     * weiterleiten
     * 
     * @param pText
     * @param pHashCode
     */
    public void checkLoginData(String pText, int pHashCode) {
        _sendMessageController.checkLoginData(pText, pHashCode);
    }
    


    /**
     * weiterleiten
     * 
     * @param pText
     * @param pAddress
     */
    public void sendTextMessage(String pText, Address pAddress) {
        _sendMessageController.sendTextMessage(pText, _currentUser, pAddress);
    }
    


    /**
     * weiterleiten
     * 
     * @param pMainView
     */
    public void addListener(IMessageReceiveListener pListener) {
        _receiveMessageThread.addListener(pListener);
    }
    


    /**
     * TODO an den Server abmelden!!!
     */
    @SuppressWarnings("deprecation")
    public void quitClient() {
        if (_sendMessageController != null) {
            _sendMessageController.sendChangeStatusMessage(_currentUser, null, Status.OFFLINE);
        }
        if (_receiverThread != null) {
            _receiverThread.stop();
        }
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyLogin(de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage)
     */
    @Override
    public void notifyLogin(ConnectionRequestMessage pMessage) {
        if (pMessage.getAddressee() != null) {
            _currentUser = (User) pMessage.getAddressee();
        }
    }
    


    /**
     * @return
     */
    public boolean isShowBullet() {
        if (_configs.get(ConfigConstants.CLIENT_SHOW_BULLET).equals("1")) {
            return true;
        }
        return false;
    }
    


    /**
     * @return
     */
    public User getCurrentUser() {
        return _currentUser;
    }
    


    /**
     * @param pName
     */
    public void createGroup(String pName) {
        if (pName != "") {
            _sendMessageController.sendCreateGroupMessage(_currentUser, null, pName);
        }
    }
    


    /**
     * @param pGroup
     * @param pUser
     */
    public void inviteToGroup(Group pGroup, User pUser) {
        _sendMessageController.sendGroupInvite(_currentUser, pUser, pGroup);
    }
    


    /**
     * @param pGroup
     */
    public void acceptGroupRequest(Group pGroup) {
        _sendMessageController.sendGroupRequest(_currentUser, null, pGroup, true);
    }
    


    /**
     * @param pListenr
     */
    public void removeListener(IMessageReceiveListener pListenr) {
        _receiveMessageThread.removeListener(pListenr);
    }
    


    /**
     * @param pAddress
     * @param pFile
     */
    public void sendFileRequest(User pAddress, File pFile) {
        _sendMessageController.sendFileTransferRequest(_currentUser, pAddress, pFile);
    }
    


    /**
     * @param pSender
     * @param pRequestFile
     */
    public void acceptFileTransfer(Address pAddressee, File pRequestFile) {
        Thread thread = new Thread(new FileTransferWaitingThread(
                _configs.get(ConfigConstants.CLIENT_DATA_PATH), Integer.parseInt(_configs
                        .get(ConfigConstants.FILE_TRANSFER_PORT))));
        thread.start();
        _sendMessageController.sendFileTransferResponse(_currentUser, pAddressee, pRequestFile,
                true, Integer.parseInt(_configs.get(ConfigConstants.FILE_TRANSFER_PORT)));
    }
    


    /**
     * @param pSender
     */
    public void acceptFriendRequest(Address pAddressee) {
        _sendMessageController.sendAnserFriendshipRequest(_currentUser, pAddressee, true);
    }
    


    /**
     * @param pSender
     */
    public void sendFriendRequest(Address pAddressee, String pMessage) {
        _sendMessageController.sendFriendshipRequest(_currentUser, pAddressee, pMessage);
    }
    


    /**
     * @param pText
     */
    public void searchUser(String pText) {
        _sendMessageController.sendSearchUser(_currentUser, pText);
    }
    


    /**
     * Logging
     * 
     * @param pMessage
     * @param pContact
     */
    public void log(Address pContact, String pMessage, Address pSender) {
        File file = new File(_configs.get(ConfigConstants.CLIENT_DATA_PATH) + ""
                + pContact.getClass().getSimpleName() + "" + pContact.getId() + ""
                + pContact.getName() + ".txt");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        try {
            FileWriter writer = new FileWriter(file, true);
            writer.write(new SimpleDateFormat("dd.MM.yyyy hh:mm").format(new Date()) + " "
                    + pSender.getName() + ": " + pMessage + "\n");
            writer.close();
        }
        catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyAddressUpdate(de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage)
     */
    @Override
    public void notifyAddressUpdate(UpdatedAdressMessage pMessage) {
        if (pMessage.getCurrentAdress() instanceof User) {
            boolean contains = false;
            for (User user : _currentUser.getKnowingUsers()) {
                if (user.getId() == pMessage.getCurrentAdress().getId()) {
                    contains = true;
                }
            }
            
            if (!contains) {
                _currentUser.getKnowingUsers().add((User) pMessage.getCurrentAdress());
            }
        }
    }
}
