package de.hwrBerlin.hwrchat.clientTest.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/**
 * 
 * @author Benni
 * 
 *         Diese Klasse kann Konfigurationsdateien lesen. Es kann unterschieden werden, ob diese fr den Server oder den Client gedacht sind. Ausgegeben werden die Konfigurationen in Form einer Map.
 *         Ein gltiges Format fr die Config-Datei sollte lauten: NameDerEinstellung = WertDerEinstellung . Alle namen und Werte mssen zusammen geschrieben werden, ansonsten wird diese Zeile
 *         ignoriert (Kommentarzeilen fangen mit einer Raute (#) an.)
 * 
 */
public class ConfigManager {
    
    // Dateiobjekt
    File file;
    
    // Server-Konfig-File?
    private boolean isServerConfig;
    
    

    public ConfigManager(boolean isServerConfig) {
        
        this.isServerConfig = isServerConfig;
        
        // Prfe zunchst, ob es ein Server-Config File sein soll.
        if (isServerConfig) {
            
            // Existiert das File?
            file = new File(ConfigConstants.SERVER_CONFIG_PATH);
            // Falls nicht, dann schreibe default-Config
            if (!file.exists() || (file.length() <= 0)) {
                writeDefaultFile();
            }
        }
        // File ist ein Client-Config-File
        else {
            // Existiert das File?
            file = new File(ConfigConstants.CLIENT_CONFIG_PATH);
            // Falls nicht, dann schreibe default-Config
            if (!file.exists()) {
                writeDefaultFile();
            }
            
        }
        
    }
    


    public Map<String, String> readConfig() {
        // Setzen des FilePaths(je nach isServerConfig)
        String tempFilePath;
        if (isServerConfig)
            tempFilePath = ConfigConstants.SERVER_CONFIG_PATH;
        else
            tempFilePath = ConfigConstants.CLIENT_CONFIG_PATH;
        
        // Variablen zum Einlesen
        String tempLine;
        BufferedReader br;
        
        try {
            br = new BufferedReader(new FileReader(tempFilePath));
            // Diese Map soll alle Properties enthalten.
            Map<String, String> configurations = new HashMap<String, String>();
            
            while ((tempLine = br.readLine()) != null) {
                /*
                 * Rufe fr jede Zeile(templine) eine Methode auf, die diese Zeile in eine Map verwandelt und fge diese der Gesamt-Property-Map hinzu
                 */
                if (readConfigLine(tempLine) != null) {
                    configurations.putAll(readConfigLine(tempLine));
                }
                
            }
            return configurations;
        }
        catch (Exception e) {
            // XXX hier knnte ein Logger stehen
            System.out.println("Konnte keine Konfiguration lesen von: " + tempFilePath);
            e.printStackTrace();
            return null;
        }
        
    }
    


    private Map<String, String> readConfigLine(String line) {
        Map<String, String> configuration = new HashMap<String, String>();
        LinkedList<String> lineArguments = cutStringLine(line);
        
        if ((lineArguments.isEmpty()) || lineArguments.getFirst().startsWith("#")) {
//            System.out.println("Ignore Config Line: " + line);
            return null;
        }
        else if (lineArguments.size() == 2) {
            configuration.put(lineArguments.get(0), lineArguments.get(1));
            return configuration;
        }
        else {
            // XXX Logger
//            System.out.println("Konnte Konfiguration nicht verarbeiten: " + line);
            return null;
        }
        
    }
    


    /**
     * Diese Methode schreibt eine Zeile in das festgelegte Config-File
     * 
     * @param key
     *            Ein Name des Schlssel
     * @param value
     *            Ein Wert, der fr diesen Schlssel gespeichert werden soll.
     */
    public void writeConfigLine(String key, String value) {
        if (key == null || key.equals("")) {
            // XXX Hier knnte geloggt werden
            System.out.println("writeConfigLine: key ist leer");
            return;
        }
        if (value == null || value.equals("")) {
            System.out.println("writeConfigLine: value ist leer");
            return;
        }
        
        String currentPath;
        if (isServerConfig)
            currentPath = ConfigConstants.SERVER_CONFIG_PATH;
        else
            currentPath = ConfigConstants.CLIENT_CONFIG_PATH;
        
        // Schreibe Datei
        PrintWriter pw;
        
        try {
            pw = new PrintWriter(new FileWriter(currentPath, true));
            pw.println(key + " = " + value);
            pw.close();
            
        }
        catch (Exception e) {
            // XXX Log-Meldung
            e.printStackTrace();
            System.out.println("Fehler beim Schreiben einer Default-Config: " + currentPath);
        }
        
    }
    


    /**
     * Diese Methode schreibt ein Default-Konfig-File
     */
    private void writeDefaultFile() {
        // Filepath
        String tempFilePath;
        
        // Liste der ConfigLines
        LinkedList<String> configLines = new LinkedList<String>();
        
        // Basis-Header
        configLines
                .add("##################################################################################");
        configLines
                .add("#Diese Datei beinhaltet verschiedene Konfigurationsmglichkeiten fr den HWR-Chat#");
        configLines
                .add("#Eine Einstellung muss dem Schema: NameDerEinstellung = Wert entsprechen         #");
        configLines
                .add("#Jede Abweichung wird ignoriert, nur bekannte Einstellungen werden bercksichtigt#");
        configLines
                .add("#Eine Raute (#) am Zeilenanfang wird ignoriert                                   #");
        configLines
                .add("##################################################################################");
        configLines.add("");
        
        // Prfe, ob ein Server-Config geschrieben werden soll
        if (isServerConfig) {
            configLines
                    .add("################################Server-Config#####################################");
            configLines.add(ConfigConstants.SERVER_DATABASE_PATH + " = localhost:3306/hwr_chat");
            configLines.add(ConfigConstants.SERVER_DATABASE_NAME + " = chat_admin");
            configLines.add(ConfigConstants.SERVER_DATABASE_PASSWORD + " = admin");
            configLines.add(ConfigConstants.SERVER_PORT + " = 50000");
            configLines.add(ConfigConstants.SERVER_USE_DEFAULT_PASSWORD + " = true");
            configLines.add(ConfigConstants.SERVER_DEFAULT_PASSWORD + " = Password");
            configLines.add(ConfigConstants.SERVER_EMAIL_SENDER_ADDRESS + " = servus@lisa-debian-server.dyndns.org");
            configLines.add(ConfigConstants.SERVER_EMAIL_SMTPHOST + " = lisa-debian-server.dyndns.org");
            configLines.add(ConfigConstants.SERVER_EMAIL_NEEDAUTHENTICATION + " = false");           
            
            tempFilePath = ConfigConstants.SERVER_CONFIG_PATH;
        }
        
        // Es ist ein Client-Config-File
        else {
            configLines
                    .add("################################Client-Config#####################################");
            configLines.add(ConfigConstants.CLIENT_SERVER_LOCAION + " = lisa-debian-server.dyndns.org");
            configLines.add(ConfigConstants.CLIENT_SERVER_PORT + " = 50000");
            configLines.add(ConfigConstants.FILE_TRANSFER_PORT + " = 1111");
            configLines.add(ConfigConstants.CLIENT_SHOW_BULLET + " = 1");
            configLines.add(ConfigConstants.CLIENT_ENABLE_LOGGING + " = 1");
            
            tempFilePath = ConfigConstants.CLIENT_CONFIG_PATH;
        }
        
        // Schreibe Datei
        PrintWriter pw;
        
        try {
            pw = new PrintWriter(new FileWriter(tempFilePath));
            // Schreibe jede Zeile aus der Liste
            for (int i = 0; i < configLines.size(); i++) {
                pw.println(configLines.get(i));
            }
            
            pw.close();
            
        }
        catch (Exception e) {
            // XXX Log-Meldung
            e.printStackTrace();
            System.out.println("Fehler beim Schreiben einer Default-Config: " + tempFilePath);
        }
        
    }
    


    /**
     * Diese Methode zerteilt den bergebenen String anhand von den Leerstellen. Im Gegensatz zur Split-Methode werden alle Leerstellen(variabel) ignoriert.
     * 
     * @param line
     *            Die Line die zerteilt werden soll.
     * @return Alle gefundenen Teilstrings werden als Liste zurckgegeben.
     */
    public static LinkedList<String> cutStringLine(String line) {
        // Hier sollen alle Teilstrings gespeichert werden.
        LinkedList<String> strings = new LinkedList<String>();
        
        /*
         * Suche die bergebene Line ab, speichere nur in Liste wenn der Teilstring selbst nicht leer ist
         */

        for (int i = 0; i < line.trim().split("=").length; i++) {
            strings.add(line.trim().split("=")[i].trim());
            
        }
        
        return strings;
    }
    
}
